package topdown.operator;

import java.util.Iterator;
import java.util.ArrayList;

import topdown.data_structures.Tuple;
import topdown.concrete_operator.*;
import topdown.term.*;

public class Relation implements Operator {

    private ArrayList<Tuple> arr;

    public Relation(Term[][] rows) {
        arr = new ArrayList<>();
        for (Term[] row : rows) {
            Tuple tuple = new Tuple();
            for (Term val : row) tuple.add(val);
            arr.add(tuple);
        }
    }

    public Iterator<Tuple> iterator() {
        return arr.iterator();
    }

    @Override
    public ConcreteOperator instance() {
        return new ConcreteRelation(this);
    }

    @Override
    public ConcreteOperator instance(int i, int c) {
        if (i <= 0 || c <= 0) return new EmptyOperator();

        return new ConcreteRelation(this);

    }
}
